/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ClipboardEntry {
    public boolean checked;
    public class_5250 text;
    public class_1799 icon;

    public ClipboardEntry(boolean checked, class_5250 text) {
        this.checked = checked;
        this.text = text;
        this.icon = class_1799.field_8037;
    }

    public ClipboardEntry displayItem(class_1799 icon) {
        this.icon = icon;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(class_1799 clipboardItem) {
        class_2487 tag = clipboardItem.method_7969();
        if (tag == null) {
            return new ArrayList<List<ClipboardEntry>>();
        }
        return NBTHelper.readCompoundList(tag.method_10554("Pages", 10), pageTag -> NBTHelper.readCompoundList(pageTag.method_10554("Entries", 10), ClipboardEntry::readNBT));
    }

    public static List<ClipboardEntry> getLastViewedEntries(class_1799 heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty()) {
            return new ArrayList<ClipboardEntry>();
        }
        int page = heldItem.method_7969() == null ? 0 : Math.min(heldItem.method_7969().method_10550("PreviouslyOpenedPage"), pages.size() - 1);
        List<ClipboardEntry> entries = pages.get(page);
        return entries;
    }

    public static void saveAll(List<List<ClipboardEntry>> entries, class_1799 clipboardItem) {
        class_2487 tag = clipboardItem.method_7948();
        tag.method_10566("Pages", (class_2520)NBTHelper.writeCompoundList(entries, list -> {
            class_2487 pageTag = new class_2487();
            pageTag.method_10566("Entries", (class_2520)NBTHelper.writeCompoundList(list, ClipboardEntry::writeNBT));
            return pageTag;
        }));
    }

    public class_2487 writeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("Checked", this.checked);
        nbt.method_10582("Text", class_2561.class_2562.method_10867((class_2561)this.text));
        if (this.icon.method_7960()) {
            return nbt;
        }
        nbt.method_10566("Icon", NBTSerializer.serializeNBT((Object)this.icon));
        return nbt;
    }

    public static ClipboardEntry readNBT(class_2487 tag) {
        ClipboardEntry clipboardEntry = new ClipboardEntry(tag.method_10577("Checked"), class_2561.class_2562.method_10877((String)tag.method_10558("Text")));
        if (tag.method_10545("Icon")) {
            clipboardEntry.displayItem(class_1799.method_7915((class_2487)tag.method_10562("Icon")));
        }
        return clipboardEntry;
    }
}

